@extends('layouts.app')

@section('header')

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Purchase</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="#">Purchase</a>
                </li>
            </ul>
        </div>
    </div>    
</div>

<div class="page-body">
    <div class="row">
        <div class="col-md-12">
            <a href="{{ URL::to('stockPurchase/create') }}" class="btn btn-primary btn-sm float-right"><i class="fas fa-plus-circle"></i> Add Purchase</a>   
        </div>
    </div>
</div>


@endsection

@section('content')
<div class="table-responsive" style="width:99%;margin-left:5px">
<table id="view-stockPurchase" class="table table-striped table-bordered" style="width:100%;">
  <thead>
    <tr>        
        <th>Purchase ID</th>        
        <th>Supplier</th>
        <th>Opening Due</th>
        <th>Opening Balance</th>
        <th>Purchase Total</th>
        <th>Discount</th>
        <th>Tax</th>
        <th>Grand total</th>
        <th>Payment</th>        
        <th>Closing Due</th>
        <th>Closing Balance</th>
        <th>Mode</th>  
        <th>Created At</th>
        <th>Action</th>            
    </tr>
  </thead>
</table>
</div>
@endsection

@section('scripts')
@include('layouts.datatables_only_files')

<script type="text/javascript">

 
$(document).ready(function() {
    var dt = $('#view-stockPurchase').DataTable({
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": true,
        "ajax":{              
                url : "/stockPurchase/index",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "purchase_id" },
            { "data": "supplier_name" },
            { "data": "opening_due" },
            { "data": "opening_balance" },
            { "data": "purchase_total" },
            { "data": "discount_amount" },
            { "data": "tax_amount" },
            { "data": "grand_total" },
            { "data": "payment" },
            { "data": "closing_due" },
            { "data": "closing_balance" },
            { "data": "mode" },
            { "data": "created_on"},
            { "data": "action" }
        ],
        "order": []
    });
 
});

</script>

@endsection
