@extends('layouts.app')

@section('header')

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Add Supplier</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('supplier/view') }}">List Supplier</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Add Supplier</a>
                </li>
            </ul>
        </div>
    </div>    
</div>

@endsection

@section('content')

<!-- Main content -->
<div class="card">
  <div class="card-header">
    <label></label>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_supplier" role="form" method="POST" action="{{ url('/supplier/store') }}">

      {{ csrf_field() }}

      <div class="box-body">
        <div class="row">

          <div class="col-sm-6">
            <div class="form-group">
              <label>Supplier Name</label><br>
              <input type="text" class="form-control" name="supplier_name" placeholder="Full name" required="required">
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
              <label>E-mail</label>
              <input type="email" class="form-control" name="supplier_email" placeholder="abc@xyz.com">
            </div>
          </div>

        </div>

        <div class="row">

          <div class="col-sm-6">
            <div class="form-group">
              <label>Description</label><br>
              <input type="number" name="description" class='form-control'/>
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
              <label>GST</label><br>
              <input type="text" name="gst" class ='form-control'/>
            </div>
          </div>

        </div>


        <div class="row">

          <div class="col-sm-12">
            <div class="form-group">
              <label>Address</label><br>
              <textarea class="form-control" placeholder="Enter current address ... " name="supplier_address"></textarea>
            </div>
          </div>

        </div>

        <div class="row">

          <div class="col-sm-6">
            <div class="form-group">
              <label>Contact Mobile</label><br>
              <input type="number" name="supplier_contact1" class ='form-control' placeholder = '' required="required" maxlength="11" minlength="10"/>
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
              <label>Alternate Mobile</label><br>
              <input type="number" name="supplier_contact2" class ='form-control' placeholder = '' maxlength="11" minlength="10"/>
            </div>
          </div>

        </div>

      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add</button>
      </div>
    </form>
  </div>
</div>

@endsection
