@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>View Outstandings</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="#">View Outstandings</a>
        </li>
      </ul>
    </div>
  </div>
</div>


@endsection


@section('content')
<div class="table-responsive"> 
  <table id="view-outstandings" class="table table-striped table-bordered" style="width:100%;">
    <thead>
    <tr>                                
        <th>Transaction ID</th>                              
        <th>Sales Id</th>
        <th>Date</th>
        <th>Customer</th>
        <th>Purchase Amount</th>
        <th>Payment</th>
        <th>Balance</th>
        <th>Due</th>                                
    </tr>
    </thead>
  </table>
  </div>
</div>
@endsection

@section('scripts')
@include('layouts.datatables_only_files')
<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#view-outstandings').DataTable( {
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": true,
        "ajax":{              
                url : "/transaction/get_outstandings",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "id" },
            { "data": "sales_id" },
            { "data": "created_at" },
            { "data": "customer.customer_name" },
            { "data": "subtotal" },
            { "data": "balance" },
            { "data": "due" }
        ],
        "order": []
    } );
 

});

</script>

@endsection
