@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>View Payments</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="#">View Payments</a>
        </li>
      </ul>
    </div>
  </div>
</div>


@endsection


@section('content')
<div class="table-responsive"> 
<table id="view-payments" class="table table-striped table-bordered" style="width:100%;">
          <thead>
          <tr>              
              <th>Transaction ID</th>            
              <th>Purchase Id</th>
              <th>Date</th>
              <th>Supplier</th>
              <th>Purchase Amount</th>
              <th>Payment</th>
              <th>Balance</th>
              <th>Due</th>              
          </tr>
          </thead>
      </table>
    </div>
</div>
@endsection

@section('scripts')
@include('layouts.datatables_only_files')
<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#view-payments').DataTable( {
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": true,
        "ajax":{              
                url : "/transaction/get_payments",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "id" },
            { "data": "purchase_id" },
            { "data": "created_at" },
            { "data": "supplier.supplier_name" },
            { "data": "subtotal" },
            { "data": "payment" },
            { "data": "balance" },
            { "data": "due" }
        ],
        "order": []
    } );
 

});

</script>

@endsection
