@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Edit Master UOM </h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('unit/view') }}">List Master UOM </a>
                </li>
                <li class="breadcrumb-item"><a href="#">Edit Master UOM </a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="card">
  <div class="card-header">
    <h5>Edit Master UOM </h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_unit" role="form" method="POST" action="{{ url('/unit/update/'.$unit->uom_id) }}">

      {{ csrf_field() }}

      <div class="box-body">
        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Measure Name</label><br>
              <input type="text" class="form-control" name="measure_name" value="{{ $unit->measure->name }}" readonly="">
            </div>
          </div>

          <div class="col-sm-12">
            <div class="form-group">
              <label>Unit</label><br>
              <input type="text" class="form-control" name="unit_name" value="{{ $unit->name }}">
            </div>
          </div>

        
          <div class="col-sm-12">
            <div class="form-group">
              <label>Short Name/Symbol</label><br>
              <input type="text" class="form-control" name="symbol" value="{{ $unit->symbol }}">
            </div>
          </div>
        </div>


      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-edit"></i> Update</button>
      </div>
    </form>
  </div>
</div>
@endsection
