@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>Master UOM</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="#">View Master UOM</a>
        </li>
      </ul>
    </div>
  </div>
</div>

<div class="page-body">
    <div class="row">
        <div class="col-md-12">
            <a href="{{ URL::to('unit/create') }}" class="btn btn-primary btn-sm float-right"><i class="fas fa-plus-circle"></i> Add Master UOM</a>   
        </div>
    </div>
</div>

@endsection

@section('content')

<table id="view-unit" class="table table-striped table-bordered" style="width:100%;">
    <thead>
        <tr>
            <th>Unit ID</th>
            <th>Unit Name</th>
            <th>Unit Symobol</th>
            <th>Measures</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>



@endsection

@section('scripts')
@include('layouts.datatables_only_files')
<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#view-unit').DataTable( {
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": true,
        "ajax":{              
                url : "/unit/index",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "uom_id" },
            { "data": "name" },
            { "data": "symbol" },
            { "data": "measure.name" },
            { "data": "action" }
        ],
        "order": []
    } );
 

});

</script>

@endsection



