<?php $__env->startSection('header'); ?>

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Quotation </h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="#">Quotation </a>
                </li>
            </ul>
        </div>
    </div>    
</div>

<div class="page-body">
    <div class="row">
        <div class="col-md-12">
            <a href="<?php echo e(URL::to('quotation/create')); ?>" class="btn btn-primary btn-sm float-right"><i class="fas fa-plus-circle"></i> Add Quotation </a>   
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="table-responsive" style="width:99%;margin-left:5px">
    <table id="dt-quotation" class="table table-striped table-bordered" style="width:100%;">
        <thead>
            <tr>
                <th>Action</th>      
                <th>Quotation #</th>                  
                <th>Customer Name</th>
                <th>Quotation Date</th> 
                <th>Total</th>
                <th>Tax</th>
                <th>Grand total</th> 
                <th>Status</th>
                <th>Created At</th>    
            </tr>
        </thead>
    </table>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<?php echo $__env->make('layouts.datatables_only_files', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<script type="text/javascript">

 
$(document).ready(function() {
  
    var dt = $('#dt-quotation').DataTable({
        searching: true,
        dom: 'lBfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "lengthMenu" : [[ 10, -1 ],[ '10', 'All' ]],
        "processing": true,
        "serverSide": true,
        "scrollX": true,
        initComplete: function () {
            this.api().columns().every(function () {
                var column = this;
                var headerText = $(column.header()).text().trim();

                // Create search input only for specific columns
                if (headerText !== 'Action' && headerText !== 'Created At' && headerText !== 'Total' && headerText !== 'Tax' && headerText !== 'Status'  && headerText !== 'Grand total') {
                    var input = $('<input type="text" class="form-control form-control-sm" placeholder="Search ' + headerText + '">')
                        .appendTo($(column.header()).empty())
                        .on('keyup change', function () {
                            column.search($(this).val()).draw();
                        });
                }
            });
        },
        "ajax":{              
                url : "/quotation/index",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "action" },
            { "data": "quotation_number" },
            { "data": "customer.name" },
            { "data": "formated_quotation_date" },
            { "data": "sub_total" },
            { "data": "tax" },
            { "data": "total" },
            { "data": "status" },
            { "data": "formated_created_at" }
        ],
        "order": []
    });
 
});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>