<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Add Product</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('product/view')); ?>">List Product</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Add Product</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
  <div class="card-header">
    <h5>Add Product</h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_product" role="form" method="POST" action="<?php echo e(url('/product/store')); ?>">

      <?php echo e(csrf_field()); ?>


      <div class="box-body">

        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Name</label><br>
              <input type="text" class="form-control" name="name">
            </div>
          </div>
        </div> 

        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Description</label><br>
              <textarea id="summernote" class="form-control" name="description"></textarea>
            </div>
          </div>
        </div> 

        <div class="row">
          <div class="col-sm-4">
            <div class="form-group">
              <label>Unit</label><br>
              <select class="form-control" name="unit">
                <?php $__currentLoopData = $measurements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($g['text']); ?>"><?php echo e(ucfirst($g['text'])); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
          </div>
          
        </div>

        <div class="row">
          <div class="col-sm-4">
            <div class="form-group">
              <label>Price</label><br>
              <input type="text" class="form-control" name="price" placeholder="0.0">
            </div>
          </div>
        </div>
       
      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add</button>
      </div>
    </form>
  </div>
</div>  
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <script type="text/javascript" src="<?php echo e(\URL::asset('js/summernote-bs4.min.js')); ?>"></script>
  <?php echo $__env->make('inventory.product.inc.script', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>