<?php $__env->startSection('header'); ?>

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Add Purchase</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('purchase/view')); ?>">List Purchase</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Add Purchase</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-block">

      <form class="form-horizontal create_purchase" role="form" 
      method="POST" action="<?php echo e(url('/purchase/store')); ?>">

        <?php echo e(csrf_field()); ?>


        <div class="box-body">


          <div class="box box-default">
            <div class="box-body">
              <div class="row">
                <div class="col-sm-3">
                  <div class="form-group">
                    <label>Branch</label>
                    <select class="form-control" name="branch_id">
                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($branch['id']); ?>"><?php echo e($branch['name']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <hr>

          <div class="box box-default">

            <div class="box-body">

              <table class="table table-striped">
                <thead>
                  <tr>
                    <th>Stock Catagory</th>
                    <th>Physical Quantity</th>
                    <th>No.of.Units</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody class="purchase_container">
                  <tr>
                    <td>
                      <input type="text" class="form-control move_search_purchase_category_name" placeholder="Type here ..." name="category_name[]" autocomplete="off">
                      <span class="help-block move_search_purchase_category_name_empty" style="display: none;">No Results Found ...</span>
                      <input type="hidden" class="move_search_category_id" name="category_id[]">
                    </td>
                    <td width="250px">
                      <select class="form-control move_purchase_stock_id" name="stock_id[]">
                        <option selected="" disabled="" value="">select</option>
                      </select>
                      <span></span>
                    </td>

                    <td width="150px">

                      <input type="hidden" class="move_search_stock_quantity" name="opening_stock[]">
                      <input type="hidden" class="closing_stock" name="closing_stock[]">

                      <input type="text" class="form-control move_change_purchase_quantity" name="purchase_quantity[]" min="0" autocomplete="off">
                      <small class="help-block max_stock" style="display: none;">Insufficient Stock</small>
                    </td>

                    <td><button type="button" class="btn btn-danger move_purchase_remove_tr">&times;</button></td>
                  </tr>
                </tbody>
                <tfoot>
                  <tr>
                    <td colspan="3">
                      <button type="button" class="btn btn-primary move_add_purchase_product"><i class="fa fa-plus"></i> Add More</button>
                    </td>
                    <td></td>
                  </tr>
                </tfoot>
              </table>

            </div>
          </div>


        </div>
        <!-- /.box-body -->

        <div class="box-footer">
          <button type="reset" class="btn btn-danger pull-left">Reset</button>
          <button type="submit" class="btn btn-primary pull-right form_submit"><i class="fa fa-plus"></i> Add</button>
        </div>
      </form>

</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <?php echo $__env->make('inventory.purchase.inc.movescript', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>