<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Employee</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('employee')); ?>">List Employee</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Add Employee</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <h5>Add Employee</h5>
    </div>
    <div class="card-block">
        <form method="post" action="<?php echo e(\URL::to('employee/save')); ?>" enctype="multipart/form-data" data-parsley-validate="">
            <?php echo e(csrf_field()); ?>

            <div class="form-group row">
            <label for="firstname" class="col-sm-2 col-form-label">First Name <i class="text-danger">*</i></label>
            <div class="col-sm-10">
                <input type="text" id="firstname" name="firstname" class="form-control" minlength="2" maxlength="50" required data-parsley-error-message="Please enter a value between 2 and 50 characters">
            </div>
        </div>

        <div class="form-group row">
            <label for="lastname" class="col-sm-2 col-form-label">Last Name <i class="text-danger">*</i></label>
            <div class="col-sm-10">
                <input type="text" id="lastname" name="lastname" class="form-control" minlength="2" maxlength="50" required data-parsley-error-message="Please enter a value between 2 and 50 characters">
            </div>
        </div>

        <div class="form-group row">
            <label for="email" class="col-sm-2 col-form-label">Email <i class="text-danger">*</i></label>
            <div class="col-sm-10">
                <input type="email" id="email" name="email" class="form-control" required data-parsley-error-message="Please enter a valid email address">
            </div>
        </div>

        <div class="form-group row">
            <label for="address" class="col-sm-2 col-form-label">Address <i class="text-danger">*</i></label>
            <div class="col-sm-10">
                <textarea id="address" name="address" class="form-control" rows="5" minlength="10" required data-parsley-error-message="Please enter a value of at least 10 characters"></textarea>
            </div>
        </div>

        <div class="form-group row">
            <label for="phnumber" class="col-sm-2 col-form-label">Phone Number</label>
            <div class="col-sm-10">
                <input type="text" id="phnumber" name="phnumber" class="form-control" minlength="6" maxlength="20" data-parsley-error-message="Please enter a value between 6 and 20 characters">
            </div>
        </div>

        <div class="form-group row">
            <label for="mobilenumber" class="col-sm-2 col-form-label">Mobile Number <i class="text-danger">*</i></label>
            <div class="col-sm-10">
                <input type="text" id="mobilenumber" name="mobilenumber" class="form-control" minlength="10" maxlength="20" required data-parsley-error-message="Please enter a value between 10 and 20 characters">
            </div>
        </div>

        <div class="form-group row">
            <label for="profilepic" class="col-sm-2 col-form-label">Profile Picture</label>
            <div class="col-sm-10">
                <input type="file" id="profilepic" name="profilepic" class="form-control-file">
            </div>
        </div>

        <div class="form-group row">
            <label for="dob" class="col-sm-2 col-form-label">Date of Birth <i class="text-danger">*</i></label>
            <div class="col-sm-10">
                <div class="input-group">
                    <input type="text" name="dob" class="form-control" id="datetimepicker1" required data-parsley-error-message="Please enter a valid date" autocomplete="off">
                    <span class="input-group-addon"><i class="fas fa-calendar-alt"></i></span>
                </div>
            </div>
        </div>

        <div class="form-group row">
            <label class="col-sm-2">Sex <i class="text-danger">*</i></label>
            <div class="col-sm-10">
                <div class="form-check">
                    <label class="form-check-label">
                        <input type="radio" class="form-check-input" name="sex" value="m" checked> Male
                    </label>
                    <label class="form-check-label">
                        <input type="radio" class="form-check-input" name="sex" value="f"> Female
                    </label>
                </div>
            </div>
        </div>

            <div class="form-group row">
                 <label for="bloodgroup" class="col-sm-2 col-form-label">Blood Group <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <select id="bloodgroup" name="bloodgroup" class=" col-sm-10"></select>
                </div>
            </div>

            <!-- <div class="form-group row">
                <label for="education" class="col-sm-2 col-form-label">Education/Degree <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <input type="text" id="education" name="education" class="form-control"  data-parsley-minlength="2" data-parsley-maxlength="50" data-parsley-required data-parsley-error-message="This field cannot be empty and value should be greater than 1 and less than 50">
                </div>
            </div> -->

            <div class="form-group row">
                 <label for="roles" class="col-sm-2 col-form-label">Roles <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <select id="roles" name="roles" class=" col-sm-10"></select>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2">Status <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <div class="form-check">
                        <label class="radio-inline">
                            <input type="radio" name="status" value="1" checked="checked">Active                  
                        </label>
                        <label class="radio-inline">
                            <input type="radio" name="status" value="0">Inactive
                        </label> 
                    </div>
                </div>
            </div>

            <div class="row">
                <label class="col-sm-2"></label>
                <div class="col-sm-10">
                    <button type="submit" class="btn btn-primary m-b-0">Save</button>
                </div>
            </div>
           
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
$(document).ready(function() {

    var role_raw_data = '<?php echo $roles; ?>';
    var role_data = JSON.parse(role_raw_data);

    var bloodGroup_raw_data = '<?php echo $bloodGroup; ?>';
    var bloodGroup_data = JSON.parse(bloodGroup_raw_data);

    $("#roles").select2({
        data: role_data
    });

    $("#bloodgroup").select2({
        data: bloodGroup_data
    });

    var FromEndDate = new Date();

    $('#datetimepicker1').datetimepicker({
        format: 'DD-MM-YYYY',
        ignoreReadonly: true,
        maxDate: 'now'
    });


});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>