<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Edit Quotation</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('quotation/view')); ?>">List Quotation</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Edit Quotation</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-block">
        <form method="post" action="<?php echo e(\URL::to('quotation/updateStatus')); ?>" data-parsley-validate="">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="quotation_id" value="<?php echo e($quotation->id); ?>">

            <div class="form-group">
                <label for="customer_id">Status</label>
                <select class="form-control" name="status" required>                    
                    <?php $__currentLoopData = $statusArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($status); ?>" <?php echo e($status == $quotation->status ? 'selected="selected"' : ''); ?>><?php echo e($status); ?></option>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="row">
                <label class="col-xl-4 col-md-4"></label>
                <div class="col-sm-10">
                    <button type="submit" class="btn btn-primary m-b-0">Update Status</button>
                </div>
            </div>           
        </form>
    </div>
</div>
        
<div class="card">
    <div class="card-block">
        <form id="paymentForm" method="post" action="<?php echo e(\URL::to('quotation/update')); ?>" data-parsley-validate="">

            <?php echo e(csrf_field()); ?>


            <?php if($errors->any()): ?>
                <div class="alert alert-danger mt-3">
                    <strong>Oops!</strong> Please fix the following errors:<br>
                    <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <input type="hidden" name="quotation_id" value="<?php echo e($quotation->id); ?>">

            <div class="row">
                <div class="col-xl-6 col-md-6">
                    
                    <div class="form-group">
                        <label for="customer_id">Customer</label>
                        <select class="form-control" id="customer_id" name="customer_id" required>
                            <option value="">-- Select Customer --</option>
                            <!-- Add options for customers here -->
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="requested_by">Requested By</label>
                        <input type="text" class="form-control" id="requested_by" name="requested_by" required   value="<?php echo e($quotation->requested_by); ?>">
                    </div>
                </div>

                <div class="col-xl-6 col-md-6">
                    <div class="form-group">
                        <label>Date</label>
                        <input type="text" class="form-control" name="quotation_date" value="<?php echo e(date('d-m-Y')); ?>" readonly   value="<?php echo e($quotation->quotation_date); ?>">
                    </div>

                    <div class="form-group">
                        <label>Quote Ref.</label>
                        <input type="text" class="form-control" name="quotation_ref" required autocomplete="off" value="<?php echo e($quotation->quotation_ref); ?>">
                    </div>

                    <div class="form-group">
                        <label>Enquiry ref.</label>
                        <input type="text" class="form-control" name="enquiry_ref" required autocomplete="off"   value="<?php echo e($quotation->enquiry_ref); ?>">
                    </div>
                </div>
            </div>

            <hr>

            <div class="row">
                <div class="col-xl-12 col-md-12">
                    <div class="box box-default">
                        <div class="box-body">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Product Name</th>
                                        <th>Quantity</th>
                                        <th>Unit</th>
                                        <th>Price</th>
                                        <th>Total</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody class="item_container">
                                    <?php $__currentLoopData = $quotationList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <input type="hidden" name="item_id[]" value="<?php echo e($list->product_id); ?>">
                                            <?php
                                                if (empty($list->catalogue))
                                                    $itemName = $list->name;
                                                else
                                                    $itemName = $list->name . " (" . $list->catalogue . ")";
                                            ?>
                                            <input type="text" style="min-width: 250px" class="form-control search_item_name" placeholder="Type here ..." name="item_name[]" autocomplete="off" value="<?php echo e($itemName); ?>">
                                            <span class="help-block search_item_name_empty" style="display: none;">No Results Found ...</span>
                                        </td>
                                        <td width="75px">
                                            <input type="number" class="form-control change_item_quantity" name="item_quantity[]" min="1" value="<?php echo e($list->quantity); ?>">
                                        </td>
                                        <td width="100px">
                                            <input type="text" class="form-control" name="unit[]" readonly="" value="<?php echo e($list->unit); ?>">
                                        </td>
                                        <td width="150px">
                                            <input type="number" class="form-control item_rate change_item_rate" name="price[]" step="0.1" value="<?php echo e($list->price); ?>">
                                        </td>
                                        <td width="150px">
                                            <input type="text" class="form-control item_total" name="sub_total[]" readonly="" value="<?php echo e($list->total); ?>">
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger remove_tr">&times;</button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="3">
                                            <button type="button" class="btn btn-primary add_item_product"><i class="fa fa-plus"></i> Add More</button>
                                        </td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-4 col-md-4">
                    <div class="form-group">
                        <label for="notes">Notes</label>
                        <textarea class="form-control" style="height: 60px;" id="notes" name="notes"></textarea>
                    </div>
                </div>
                <div class="col-xl-4 col-md-4">
                    <!-- You can add more fields here if needed -->
                </div>
                <div class="col-xl-4 col-md-4">
                    <div class="form-group">
                        <label>Sub Total</label>
                        <input type="text" class="form-control final_total_bill" readonly name="final_total_bill" value="<?php echo e($quotation->sub_total); ?>">
                    </div>
                    <div class="form-group">
                        <label>Tax Amount</label>
                        <input type="text" class="form-control item_tax_amount" readonly name="tax_percent" value="<?php echo e($quotation->tax); ?>">
                    </div>
                    <div class="form-group">
                        <label>Grand Total</label>
                        <input type="text" class="form-control grand_total" readonly name="grand_total" value="<?php echo e($quotation->total); ?>">
                    </div>
                </div>
            </div>

            <div class="row">
                <label class="col-xl-4 col-md-4"></label>
                <div class="col-sm-10">
                    <button type="submit" class="btn btn-primary m-b-0 form_submit">Update</button>
                </div>
            </div>

           
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('inventory.quotation.inc.script', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <script type="text/javascript">

        $('tbody').sortable();
        var customers_raw_data = '<?php echo $customers; ?>';
        var customers_data = JSON.parse(customers_raw_data);

        $("#customer_id").select2({
            data: customers_data
        });  

        var customer_id = '<?php echo $quotation->customer_id; ?>';

        $('#customer_id').val(customer_id);
        $('#customer_id').trigger('change'); 
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>